definition module clCrossCall

import intrface, StdEnv


  //----------------------------------------------//
 //    Cursor related crosscalls                 //
//----------------------------------------------//


WinSetWindowCursor :: !HWND !Int !OS -> OS

WinObscureCursor :: !OS -> OS


  //----------------------------------------------//
 //    Dialog related crosscalls                 //
//----------------------------------------------//

WinBeep :: !OS -> OS

WinEnableControl :: !HWND !Bool !OS -> OS
WinEnablePopupItem :: !HWND !Int !Bool !OS -> OS
WinCheckControl  :: !HWND !Bool !OS -> OS
WinSelectPopupItem :: !HWND !Int !OS -> OS


  //----------------------------------------------//
 //    Timer related crosscalls                  //
//----------------------------------------------//

WinCreateTimer :: !Int !OS -> (!HITEM, !OS)
WinKillTimer :: !Int !OS -> OS
WinSetIdleTimer :: !Bool !OS -> OS

WinGetTime :: !OS -> (!(!Int,!Int,!Int),!OS)
WinGetDate :: !OS -> (!(!Int,!Int,!Int,!Int),!OS)

WinWait :: !Int !OS -> OS
WinGetBlinkTime :: !OS -> (!Int,!OS)


  //----------------------------------------------//
 //    Window related crosscalls                 //
//----------------------------------------------//

WinSetWindowTitle :: !HWND !String !OS -> OS
WinGetWindowText  :: !HWND !OS -> (!String, !OS)

WinInvalidateWindow :: !HWND !OS -> OS

WinBeginPaint :: !HWND        !OS -> (!HDC, !OS) 
WinEndPaint   :: !HWND !(!HDC, !OS) -> OS

WinGetDC :: !HWND !OS -> (!HDC, !OS) 
WinReleaseDC :: !HWND !(!HDC, !OS) -> OS

WinGetActiveDialog     :: !OS -> (!HWND, !OS)
WinGetForegroundWindow :: !OS -> (!HWND, !OS)

WinSetScrollInfos :: !HWND !(!(!Int,!Int),!(!Int,!Int)) !(!Int,!Int,!Int,!Int) !OS -> OS
WinGetClientSize :: !HWND !OS -> ( !(!Int,!Int), !OS)
WinGetWindowPos :: !HWND !OS -> (!(!Int,!Int), !OS)
WinGetScrollWinFrameSize :: !HWND !OS -> ( !(!Int,!Int), !OS)

  //----------------------------------------------//
 //    Menu related crosscalls                   //
//----------------------------------------------//

WinCreateMenuBarHandle	::										 !OS -> (!HMENU, !OS)
WinCreateMenuWindow		:: !HMENU !String						 !OS -> (!HWND,  !OS)
WinCreatePopupMenuHandle::										 !OS -> (!HMENU, !OS)
WinAppendMenu			:: !String !Bool !HMENU !HMENU		     !OS -> OS
WinAppendMenuItem       :: !String !Bool !Bool !HMENU            !OS -> (!HITEM, !OS)
WinAppendSeparator		:: !HMENU								 !OS -> OS
WinInsertMenuItem       :: !String !Bool !Bool !HMENU !Int       !OS -> (!HITEM, !OS)
WinInsertSeparator		:: !HMENU !Int							 !OS -> OS
WinChangeMenuItemCheck  :: !HMENU !HITEM !Bool                   !OS -> OS
WinModifyMenu			:: !String !Bool !HMENU !HMENU !Int      !OS -> OS
WinModifyMenuItem       :: !HITEM !String !Bool !Bool !HMENU     !OS -> OS
WinRemoveMenuItem       :: !HMENU !HITEM                         !OS -> OS
WinChangeItemAbility    :: !HMENU !HITEM !Bool                   !OS -> OS
WinChangeMenuAbility	:: !HMENU !Int !Bool					 !OS -> OS
WinDrawMenuBar			::										 !OS -> OS

  //----------------------------------------------//
 //    Crosscall infrastructure                  //
//----------------------------------------------//


ErrorCallback :: !String !CrossCallInfo !u:s !OS -> (!Bool, !CrossCallInfo, !u:s, !OS)

IssueCleanRequest :: !(CrossCallInfo -> .(.s -> .(*OS -> *(.Bool,.CrossCallInfo,.s,*OS)))) !.CrossCallInfo !.s !*OS -> *(!CrossCallInfo,!.s,!*OS)


Return0Cci   ::				                     CrossCallInfo
Return1Cci   :: !Int			              -> CrossCallInfo
Return2Cci   :: !Int !Int		              -> CrossCallInfo
Return3Cci   :: !Int !Int !Int                -> CrossCallInfo
Return4Cci   :: !Int !Int !Int !Int           -> CrossCallInfo
Return5Cci   :: !Int !Int !Int !Int !Int      -> CrossCallInfo
Return6Cci   :: !Int !Int !Int !Int !Int !Int -> CrossCallInfo

  //----------------------------------------------//
 //  Showing messages, and printing to stdout    //
//----------------------------------------------//

Ibeep :: .a -> .a

//Iprint string a :== a
//Iprint` string a :== a
Iprint  :: !String !.a -> .a
Iprint` :: !String !.a -> .a

instance toInt Bool

  //----------------------------------------------//
 //    Clipboard related crosscalls              //
//----------------------------------------------//

WinGetClipboardText :: !OS -> (!String, !OS)
WinSetClipboardText :: !String !OS -> OS

